/**@@@+++@@@@******************************************************************
**
** Microsoft Windows Media
** Copyright (C) Microsoft Corporation. All rights reserved.
**
***@@@---@@@@******************************************************************
*/

#include "tGetClientID.h"
#include "oemimpl.h"
#include "drmkeygenerator.h"
#include "drmutilities.h"
#include "drmcontextsizes.h"

DRM_RESULT TestGetClientID(CLIENTID *pClientID)
{
	DRM_RESULT dr;    
    DRM_BYTE rgbBuffer[__CB_DECL(MAX_DEVICE_CERT_SIZE)];
    DRM_DWORD cbBuffer = SIZEOF( rgbBuffer );
    DRM_STRING dstrDevCert;
	DRM_BB_CONTEXT oBBContext = {0};

    DSTR_FROM_PB( &dstrDevCert, rgbBuffer, cbBuffer );
    ChkDR( DRM_DDC_GetDeviceCertificate( &dstrDevCert, 0, &oBBContext.CryptoContext ) );
    ChkDR( DRM_DCP_LoadPropertiesCache( (DRM_CONST_STRING*) &dstrDevCert, &oBBContext.cachedCertValues, &oBBContext.CryptoContext ) );

	/* Initialize blackbox */
	ChkDR(DRM_BBX_Initialize(&oBBContext));

	ChkDR(DRM_BBX_GetClientId(pClientID, &oBBContext));
ErrorExit:
	DRM_BBX_Shutdown(&oBBContext);
	return dr;
}

